#include "Level.h"
#include "gameloop.h"
#include "SDL_image.h"

void showMission(GameState* gs, Level& level);

extern SDL_Surface* bonusHousePic;

Level::Level()
    : playerX(400)
    , playerY(300)
    , terrainFile(NULL)
    , bgFile(NULL)
    , missionText(NULL)
{

}

void Level::load(GameState* state)
{
    state->complete = false;
    state->nextLevelTimer = 2.000;
    state->houses = houses;
    state->fires = fires;

    if(state->bonus)
    {
        state->bonusPlayer = state->player;
        state->player = new Player(true);
        for(list<House>::iterator e = state->houses.begin(); e != state->houses.end(); e++)
            (*e).pic = bonusHousePic;
    }

    state->player->hp = 100;
    state->player->x = playerX;
    state->player->y = playerY;

    SDL_FreeSurface(state->grass);
    state->grass = SPG_DisplayFormat(IMG_Load(bgFile));

    SDL_Surface* terrain = IMG_Load(terrainFile);
    state->terrainMap->load(terrain);
    SDL_FreeSurface(terrain);

    state->burnMap->load(state->terrainMap);

    state->savedGrass = state->burnMap->getSaved();

    showMission(state, *this);
}


bool loadLevel(GameState* state, int num)
{
    Level l;
    Fire f(0,0);
    f.growthFactor = 10;
    f.deathFactor = 1;
    f.speed = 7;
    f.size = 10;
    f.isWild = true;
    if(state->bonus)
    {
        // Swap back in the real player
        delete state->player;
        state->player = state->bonusPlayer;
        state->bonus = false;
    }

    switch(num)
    {
        case 1:
            l.playerX = 100;
            l.playerY = 400;
            l.houses.push_back(House(117, 321));
            l.houses.push_back(House(394, 372));
            l.houses.push_back(House(323, 276));
            f.x = 686;
            f.y = 273;
            f.size = 10;
            l.fires.push_back(f);
            l.terrainFile = "levels/level1.png";
            l.bgFile = "levels/level1.jpg";
            l.missionText = "Mission1\n\n"
                            "Your first mission is in the nearby town of Riversford.\n"
                            "A rapidly growing fire has just broken out at a landfill\n"
                            "and cannot be contained without expert action.\n"
                            "If you act quickly, none of the evacuated\n"
                            "properties might be damaged.\n"
                            "Good luck.";
        break;
        case 2:
            l.playerX = 611;
            l.playerY = 569;
            l.houses.push_back(House(501, 507));
            l.houses.push_back(House(433, 397));
            l.houses.push_back(House(480, 402));
            l.houses.push_back(House(259, 383));
            f.x = 478;
            f.y = 211;
            f.size = 10;
            l.fires.push_back(f);
            l.terrainFile = "levels/level2.png";
            l.bgFile = "levels/level2.jpg";
            l.missionText = "Mission2\n\n"
                            "A fire has been reported at the Pennies resort.\n"
                            "Get over there and stomp it out.\n"
                            "Use the terrain to your advantage.";
        break;
        case 3:
            state->bonus = true;
            l.playerX = 400;
            l.playerY = 201;
            for(int i = 0; i < 30; i++)
                l.houses.push_back(House(rand()%800, rand()%600));
            l.terrainFile = "levels/level3.png";
            l.bgFile = "levels/level3.jpg";
            l.missionText = "Bonus Round!\n\n"
                            "You have 15 seconds to...\n\n"
                            "Burninate!!!";
        break;
        case 4:
            l.playerX = 126;
            l.playerY = 377;
            l.houses.push_back(House(216, 337));
            l.houses.push_back(House(75, 357));
            l.houses.push_back(House(168, 427));
            l.houses.push_back(House(220, 495));
            f.x = 684;
            f.y = 267;
            f.size = 10;
            l.fires.push_back(f);
            l.terrainFile = "levels/level4.png";
            l.bgFile = "levels/level4.jpg";
            l.missionText = "Mission4\n\n"
                            "Your trip to Banana Island is no vacation.\n"
                            "There's a wildfire starting in the eastern forest.";
        break;
        case 5:
            l.playerX = 401;
            l.playerY = 232;
            l.houses.push_back(House(599, 317));
            l.houses.push_back(House(274, 439));
            l.houses.push_back(House(197, 357));
            l.houses.push_back(House(436, 303));
            l.houses.push_back(House(593, 139));
            f.x = 31;
            f.y = 299;
            f.size = 10;
            l.fires.push_back(f);
            f.x = 756;
            f.y = 319;
            f.size = 10;
            l.fires.push_back(f);
            l.terrainFile = "levels/level5.png";
            l.bgFile = "levels/level5.jpg";
            l.missionText = "Mission5\n\n"
                            "The town of Isthmus is in serious trouble!\n"
                            "You've never faced two fires at once.\n"
                            "Stay diligent and don't let the embers break\n"
                            "your line.";
        break;
        case 6:
            l.playerX = 781;
            l.playerY = 47;
            f.x = 310;
            f.y = 297;
            f.size = 10;
            l.fires.push_back(f);
            f.x = 532;
            f.y = 501;
            f.size = 10;
            l.fires.push_back(f);
            f.x = 33;
            f.y = 92;
            f.size = 10;
            l.fires.push_back(f);
            f.x = 618;
            f.y = 257;
            f.size = 10;
            l.fires.push_back(f);
            l.terrainFile = "levels/level6.png";
            l.bgFile = "levels/level6.jpg";
            l.missionText = "Mission6\n\n"
                            "We've come to stop this forest fire,\n"
                            "but this is too much for us!\n"
                            "Get out of there safely, however\n"
                            "you can manage!";
        break;
        case 7:
            l.playerX = 471;
            l.playerY = 274;
            l.houses.push_back(House(299, 289));
            l.houses.push_back(House(562, 436));
            l.houses.push_back(House(75, 358));
            l.houses.push_back(House(728, 447));
            l.houses.push_back(House(402, 458));
            f.x = 52;
            f.y = 535;
            f.size = 10;
            l.fires.push_back(f);
            f.x = 575;
            f.y = 531;
            f.size = 10;
            l.fires.push_back(f);
            f.x = 555;
            f.y = 541;
            f.size = 10;
            l.fires.push_back(f);
            l.terrainFile = "levels/level7.png";
            l.bgFile = "levels/level7.jpg";
            l.missionText = "Mission7\n\n"
                            "The rural lake community of Taco Lake is\n"
                            "totally screwed.\n\n"
                            "Oh wait, I'm supposed to be optimistic...";
        break;
        default:
            return false;  // Game over
    };

    l.load(state);
    return true;
}
